*
* TCPDUMP-STYLE DEMO INTERFACE USED FOR TESTING
*
DEMOLOOP
:KBD LDA KBD ; CHECK FOR KEYPRESS
 BMI :PRESS ; KEY PRESSED
 JMP MAINLOOP ; NO PRESS
:PRESS STA KBDSTRB ; CLEAR STROBE
 CMP #"A" ; SHOULD WE SEND AN ARP ANNOUNCE?
 BNE :ARPR
 JSR ARPANNOUNCE
 JMP MAINLOOP
:ARPR CMP #"R" ; SEND AN ARP REQUEST?
 BNE :ESC
 JSR ARPTEST
 JMP MAINLOOP
:ESC CMP #ESC ; WAS IT ESCAPE?
 BNE :T
* PRINT THE IP COUNTER BEFORE WE EXIT
 DO DEBUG
 JSR CROUT
 LDA IPCOUNT+1
 LDX IPCOUNT
 JSR PRNTAX
 JSR CROUT
 FIN
 JMP DOSWARM ; EXIT THIS PROGRAM
*
:T CMP #"T" ; WAS IT A T
 BEQ :ARPTAB
 CMP #"I"
 BEQ :PRINTIPADDR
 CMP #"S" ; WAS IT AN S?
 BEQ :SENDTEST
 CMP #"D" ; WAS IT A D?
 BEQ :DHCPTEST
 DO ENABLEDNS
 CMP #"L"
 BEQ :DNSTEST
 FIN
 CMP #"O"
 BNE :NOTO
 JMP :OPENSOCK
:NOTO
 CMP #"P"
 BNE :NOTP
 JMP :RECVSOCK
:NOTP
 JMP MAINLOOP
 DO ENABLEDNS
:DNSTEST
 JSR DNSTEST
 JMP MAINLOOP
 FIN
* SEND A DHCP DISCOVERY BROADCAST
:DHCPTEST
 JSR DHCPSENDDISC
 JMP MAINLOOP
* PRINT THE ARP TABLE
:ARPTAB
 LDY #0
:L LDA MSG11,Y
 BEQ :NEXT
 JSR COUT
 INY
 BNE :L
:NEXT JSR PRNTARPTAB
 JMP MAINLOOP ; ALL DONE
* PRINT CURRENT IP ADDRESS
:PRINTIPADDR
 LDA #$8D
 JSR COUT
 LDA #<IPADDR
 STA PTR
 LDA #>IPADDR
 STA PTR+1
 JSR PRNTIPDEC
 JMP MAINLOOP
*
*
* SEND TEST FOR UDP
:SENDTEST
 LDA #<:SOCKPARAM1
 STA PTR
 LDA #>:SOCKPARAM1
 STA PTR+1
 JSR SOCKET
 LDA :SOCKPARAM1+1 ; GET SOCKET ID
 STA :SOCKPARAM2 ; STORE FOR SENDTO CALL
 STA :SOCKPARAM3 ; AND SCLOSE CALL TOO
* GET DESTINATION ADDR
 LDY #0
:UDPIL LDA MSG21,Y
 BEQ :SENDTEST2
 JSR COUT
 INY
 BNE :UDPIL
:SENDTEST2
 LDA #">"
 STA $33 ; PROMPT
 JSR GETLN
 LDA #0
 STA PTR
 STA $0200,X
 LDA #2
 STA PTR+1
 JSR IPTOHEX
* COPY DESTINATION ADDRESS
 LDA IPHEXTMP
 STA :SOCKPARAM2+1
 LDA IPHEXTMP+1
 STA :SOCKPARAM2+2
 LDA IPHEXTMP+2
 STA :SOCKPARAM2+3
 LDA IPHEXTMP+3
 STA :SOCKPARAM2+4
* DESTINATION PORT: ALWAYS 6502
 LDA #$66
 STA :SOCKPARAM2+5
 LDA #$19
 STA :SOCKPARAM2+6
* READ IN USER'S MESSAGE TO SEND
 LDY #0
:STML LDA MSG5,Y
 BEQ :SMTNEXT
 JSR COUT
 INY
 BNE :STML
:SMTNEXT
 LDA #">"
 STA $33
 JSR GETLN
 LDA #$0A ; NEW LINE
 STA $200,X
 INX
* SET OUTPBUF
 LDA #0
 STA OUTPBUF
 STA :SOCKPARAM2+7
 LDA #$02
 STA OUTPBUF+1
 STA :SOCKPARAM2+8
* SET LENGTH
 STX OUTPLEN
 STX :SOCKPARAM2+9
 LDA #0
 STA OUTPLEN+1
 STA :SOCKPARAM2+10
* CLEAR HI-BIT ON ASCII
 DEX
:STL2 LDA $200,X
 AND #$7F
 STA $200,X
 DEX
 BNE :STL2
 LDA $200,X
 AND #$7F
 STA $200,X
* CALL SENDTO AND SEE WHAT HAPPENS
 LDA #<:SOCKPARAM2
 STA PTR
 LDA #>:SOCKPARAM2
 STA PTR+1
 JSR SENDTO
 BCS :SENDERR
 BCC :SCLOSE
:SENDERR
 LDA #$8D
 JSR COUT
 LDA #"E"
 JSR COUT
:SCLOSE
 LDA #<:SOCKPARAM3
 STA PTR
 LDA #>:SOCKPARAM3
 STA PTR+1
 JSR SCLOSE
 JMP MAINLOOP
:SOCKPARAM1 HEX 0100 ; SOCKET
:SOCKPARAM2 HEX 0000000000 ; SENDTO
 HEX 0000 ; SENDTO - DEST PORT
 HEX 00000000 ; SENDTO - BUFFER AND LENGTH
:SOCKPARAM3 HEX 00 ; SCLOSE
*
:OPENSOCK
 LDA :SOCKPARAM4+1 ; CHECK SOCKET OPEN
 BEQ :OPENSOCK2 ; NOT OPEN
 LDA #<:SOCKPARAM7
 STA PTR
 LDA #>:SOCKPARAM7
 STA PTR+1
 JSR SCLOSE
 LDA #$8D
 JSR COUT
 LDA #"C"
 JSR COUT
 LDA #0
 STA :SOCKPARAM4+1
 JMP MAINLOOP
* OPEN SOCKET
:OPENSOCK2
 LDA #<:SOCKPARAM4
 STA PTR
 LDA #>:SOCKPARAM4
 STA PTR+1
 JSR SOCKET
 LDA :SOCKPARAM4+1
 STA :SOCKPARAM5
 STA :SOCKPARAM6
 STA :SOCKPARAM7
 JSR PRBYTE
* BIND TO PORT 6502
 LDA #<:SOCKPARAM5
 STA PTR
 LDA #>:SOCKPARAM5
 STA PTR+1
 JSR BIND
 LDA #"O"
 JSR COUT
 LDA #$8D
 JMP MAINLOOP
:SOCKPARAM4 HEX 0100 ; SOCKET
:SOCKPARAM5 HEX 006619 ; BIND
:SOCKPARAM6 DS 11 ; RECVFROM
:SOCKPARAM7 HEX 00 ; SCLOSE
*
:RECVSOCK
 LDA :SOCKPARAM4+1 ; CHECK SOCKET OPEN
 BEQ :RECVSOCK2 ; NOT OPEN
 LDA #<:SOCKPARAM6
 STA PTR
 LDA #>:SOCKPARAM6
 STA PTR+1
 JSR RECVFROM
 BCS :RECVSOCK2 ; NOTHING
 LDA :SOCKPARAM6+1
 ORA :SOCKPARAM6+2
 BEQ :RECVSOCK2 ; NOTHING TO READ
* PRINT ALL DATA IN ASCII
 LDA :SOCKPARAM6+1
 STA INPBUF
 LDA :SOCKPARAM6+2
 STA INPBUF+1
 LDA #$8D
 JSR COUT
* DO FIRST PAGES OF 256 BYTES
 LDY #0
 LDA :SOCKPARAM6+4 ; GET HI BYTE
 BEQ :RECVLAST
 TAX
:RECVL
 LDA (INPBUF),Y
 ORA #$80
 JSR COUT
 INY
 BNE :RECVL
 INC INPBUF+1
 DEX
 BNE :RECVL
:RECVLAST
 LDX :SOCKPARAM6+3
:RECVL2
 LDA (INPBUF),Y
 ORA #$80
 JSR COUT
 INY
 DEX
 BNE :RECVL2
*
 LDA #$8D
 JSR COUT
:RECVSOCK2
 JMP MAINLOOP
